﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Cohorts
{
    public partial class Registry : BasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
                ServiceInterfaceManager.LogInformation("PAGE_LOAD", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Page_Load(sender, e);
                //BuildCohortsMenu();

                lblResult.Text = string.Empty;

                if (!UserSession.IsSystemAdministrator && UserSession.IsRegistryAdministrator)
                {
                    linkRegistryAdd.Visible = false;
                }

                if (!Page.IsPostBack)
                {
                    txtRegistryDescription.Attributes.Add("maxlength", txtRegistryDescription.MaxLength.ToString());

                    if (UserSession.CurrentRegistryId > 0)
                    {
                        RegistryEdit(UserSession.CurrentRegistryId);
                    }
                    else
                    {
                        pnlRegistries.Visible = true;
                        pnlRegistry.Visible = false;
                        btnNext.Visible = false;
                    }
                }

                //Added for 508 compliance with GridView column headers and footer
                Page.ClientScript.RegisterStartupScript(this.GetType(), "UpdateGridView", "UpdateGridView('" + gridRegistry.ClientID + "');", true);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkRegistryAdd_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                RegistryAdd();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkEdit_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                LinkButton lb = (LinkButton)sender;
                if (lb != null)
                {
                    int id = 0;

                    if (int.TryParse(lb.CommandArgument, out id))
                    {
                        UserSession.CurrentRegistryId = id;

                        SiteMaster master = (SiteMaster)this.Master;
                        master.BuildMenu();

                        RegistryEdit(id);
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkDelete_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                LinkButton lb = (LinkButton)sender;
                if (lb != null)
                {
                    int id = 0;

                    string[] args = new string[2];
                    args = lb.CommandArgument.ToString().Split(';');

                    if (int.TryParse(args[0], out id))
                    {
                        string code = args[1];
                        if (code == "CRS")
                        {
                            lblResult.Text = "This core registry cannot be deleted.";
                            return;
                        }

                        ServiceInterfaceManager.STD_REGISTRY_DELETE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, id);
                        gridRegistry.DataBind();
                        lblResult.Text = "Registry has been deleted.";
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkName_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                LinkButton lb = (LinkButton)sender;
                if (lb != null)
                {
                    int id = 0;

                    if (int.TryParse(lb.CommandArgument, out id))
                    {
                        UserSession.CurrentRegistryId = id;
                        Response.Redirect("~/Cohorts/Cohort.aspx", false);
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnSave_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                string strResult = string.Empty;

                if (SaveForm(ref strResult))
                {
                    gridRegistry.DataBind();

                    pnlRegistries.Visible = false;
                    pnlRegistry.Visible = true;
                    btnNext.Visible = true;
                }
                else
                {
                    pnlRegistries.Visible = false;
                    pnlRegistry.Visible = true;
                    btnNext.Visible = false;
                }

                lblResult.Text = strResult;
            }
            catch (Exception ex)
            {
                if (ex.Message.ToLower().Contains("already exists"))
                    lblResult.Text = "The Registry/Cohort you are saving already exists<br /><br />";
                else
                {
                    ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    throw ex;
                }
            }
        }

        protected void BtnCancel_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                UserSession.CurrentRegistryId = 0;
                UserSession.CurrentSurveyId = 0;

                ResetForm();
                pnlRegistries.Visible = true;
                pnlRegistry.Visible = false;
                btnNext.Visible = false;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnBack_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                bool blnContinue = false;
                string strResult = string.Empty;
                blnContinue = SaveForm(ref strResult);

                if (blnContinue)
                {
                    UserSession.CurrentRegistryId = 0;
                    UserSession.CurrentSurveyId = 0;

                    ResetForm();
                    pnlRegistries.Visible = true;
                    pnlRegistry.Visible = false;
                    btnNext.Visible = false;
                }
                else
                    lblResult.Text = strResult;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnNext_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                bool blnContinue = false;
                string strResult = string.Empty;
                blnContinue = SaveForm(ref strResult);

                if (blnContinue)
                {
                    int id = 0;

                    if (int.TryParse(hideRegistryId.Value, out id))
                    {
                        UserSession.CurrentRegistryId = id;
                        Response.Redirect("~/Cohorts/Cohort.aspx", false);
                    }
                }
                else
                    lblResult.Text = strResult;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkContinue_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                int id = 0;

                if (int.TryParse(hideRegistryId.Value, out id))
                {
                    RegistryEdit(id);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkNew_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                RegistryAdd();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private void RegistryAdd()
        {
            ResetForm();
            pnlRegistries.Visible = false;
            pnlRegistry.Visible = true;
            btnNext.Visible = false;
        }

        private void RegistryEdit(int STD_REGISTRY_ID)
        {
            LoadForm(STD_REGISTRY_ID);
            pnlRegistries.Visible = false;
            pnlRegistry.Visible = true;
            btnNext.Visible = true;
        }

        public bool SaveForm(ref string strResult)
        {
            STD_REGISTRY registry = null;

            if (string.IsNullOrEmpty(txtRegistryName.Text))
            {
                strResult = "<ul><li>Registry Name is Required</li></ul>";
            }
            else if (string.IsNullOrEmpty(txtRegistryCode.Text))
            {
                strResult = "<ul><li>Abbreviation is Required</li></ul>";
            }
            else if (string.IsNullOrEmpty(txtRegistryDescription.Text))
            {
                strResult = "<ul><li>Description is Required</li></ul>";
            }
            else
            {
                int id = 0;
                if (!string.IsNullOrEmpty(hideRegistryId.Value))
                {
                    int.TryParse(hideRegistryId.Value, out id);
                }

                registry = ServiceInterfaceManager.STD_REGISTRY_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, id);
                if (registry == null) registry = new STD_REGISTRY();

                registry.CREATED = registry.UPDATED = DateTime.Now;
                registry.CREATEDBY = registry.UPDATEDBY = HttpContext.Current.User.Identity.Name;
                registry.NAME = txtRegistryName.Text;
                registry.CODE = txtRegistryCode.Text.Trim();
                registry.DESCRIPTION_TEXT = txtRegistryDescription.Text;

                int userId = 0;
                int.TryParse(listRegistryOwner.SelectedValue, out userId);
                if (userId > 0)
                    registry.REGISTRY_OWNER = userId;
                else
                    registry.REGISTRY_OWNER = null;

                userId = 0;
                int.TryParse(listRegistryAdministrator.SelectedValue, out userId);
                if (userId > 0)
                    registry.REGISTRY_ADMINISTRATOR = userId;
                else
                    registry.REGISTRY_ADMINISTRATOR = null;

                userId = 0;
                int.TryParse(listSupportContact.SelectedValue, out userId);
                if (userId > 0)
                    registry.REGISTRY_SUPPORT_CONTACT = userId;
                else
                    registry.REGISTRY_SUPPORT_CONTACT = null;

                registry.ID = ServiceInterfaceManager.STD_REGISTRY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, registry);
                if (registry.ID > 0)
                {
                    ApplicationSession.Refresh(false);
                    hideRegistryId.Value = registry.ID.ToString();

                    if (SaveSchedule(ref strResult, registry.ID))
                    {
                        if (SaveMiscellaneousInfo(ref strResult, registry.ID))
                        {
                            strResult = "Save successful<br /><br />";
                            return true;
                        }
                    }
                }
                else
                {
                    strResult = "Error saving Registry, please try again<br /><br />";
                }
            }

            return false;
        }

        private bool SaveSchedule(ref string strResult, int registryId)
        {
            SETTINGS setting = null;
            setting = ServiceInterfaceManager.SETTINGS_GET_REGISTRYNAME(HttpContext.Current.User.Identity.Name, registryId, "EtlScheduleManual");
            if (setting == null)
            {
                setting = new SETTINGS();
                setting.CREATED = DateTime.Now;
                setting.CREATEDBY = HttpContext.Current.User.Identity.Name;
                setting.NAME = "EtlScheduleManual";
                setting.STD_REGISTRY_ID = registryId;
            }

            setting.UPDATED = DateTime.Now;
            setting.UPDATEDBY = HttpContext.Current.User.Identity.Name;
            if (rblScheduleManual.SelectedItem == null)
            {
                setting.VALUE = "0";
            }
            else
            {
                setting.VALUE = rblScheduleManual.SelectedValue;
            }
            setting.CRS_SETTINGS_ID = ServiceInterfaceManager.SETTINGS_SAVE(HttpContext.Current.User.Identity.Name, registryId, setting);
            if (setting.CRS_SETTINGS_ID <= 0)
            {
                strResult = "Registry and Contact Information have been saved, however there was an error saving Schedule Information.  Please try again.<br /><br />";
                return false;
            }

            setting = ServiceInterfaceManager.SETTINGS_GET_REGISTRYNAME(HttpContext.Current.User.Identity.Name, registryId, "EtlScheduleAuto");
            if (setting == null)
            {
                setting = new SETTINGS();
                setting.CREATED = DateTime.Now;
                setting.CREATEDBY = HttpContext.Current.User.Identity.Name;
                setting.NAME = "EtlScheduleAuto";
                setting.STD_REGISTRY_ID = registryId;
            }

            setting.UPDATED = DateTime.Now;
            setting.UPDATEDBY = HttpContext.Current.User.Identity.Name;
            if (rblScheduleAuto.SelectedItem == null)
            {
                setting.VALUE = "0";
            }
            else
            {
                setting.VALUE = rblScheduleAuto.SelectedValue;
            }
            setting.CRS_SETTINGS_ID = ServiceInterfaceManager.SETTINGS_SAVE(HttpContext.Current.User.Identity.Name, registryId, setting);
            if (setting.CRS_SETTINGS_ID <= 0)
            {
                strResult = "Registry and Contact Information have been saved, however there was an error saving Schedule Information.  Please try again.<br /><br />";
                return false;
            }

            setting = ServiceInterfaceManager.SETTINGS_GET_REGISTRYNAME(HttpContext.Current.User.Identity.Name, registryId, "EtlScheduleAutoTime");
            if (setting == null)
            {
                setting = new SETTINGS();
                setting.CREATED = DateTime.Now;
                setting.CREATEDBY = HttpContext.Current.User.Identity.Name;
                setting.NAME = "EtlScheduleAutoTime";
                setting.STD_REGISTRY_ID = registryId;
            }

            setting.UPDATED = DateTime.Now;
            setting.UPDATEDBY = HttpContext.Current.User.Identity.Name;
            if (listScheduleAutoTime.SelectedItem == null)
            {
                setting.VALUE = "0";
            }
            else
            {
                setting.VALUE = listScheduleAutoTime.SelectedValue;
            }
            setting.CRS_SETTINGS_ID = ServiceInterfaceManager.SETTINGS_SAVE(HttpContext.Current.User.Identity.Name, registryId, setting);
            if (setting.CRS_SETTINGS_ID <= 0)
            {
                strResult = "Registry and Contact Information have been saved, however there was an error saving Schedule Information.  Please try again.<br /><br />";
                return false;
            }

            return true;
        }

        private bool SaveMiscellaneousInfo(ref string strResult, int registryId)
        {
            SETTINGS setting = null;
            setting = ServiceInterfaceManager.SETTINGS_GET_REGISTRYNAME(HttpContext.Current.User.Identity.Name, registryId, "UploadNoteTemplates");
            if (setting == null)
            {
                setting = new SETTINGS();
                setting.CREATED = DateTime.Now;
                setting.CREATEDBY = HttpContext.Current.User.Identity.Name;
                setting.NAME = "UploadNoteTemplates";
                setting.STD_REGISTRY_ID = registryId;
            }

            setting.UPDATED = DateTime.Now;
            setting.UPDATEDBY = HttpContext.Current.User.Identity.Name;
            if (chkbxAllowSurveys.Checked == false)
            {
                setting.VALUE = "0";
            }
            else
            {
                setting.VALUE = "1";
            }
            setting.CRS_SETTINGS_ID = ServiceInterfaceManager.SETTINGS_SAVE(HttpContext.Current.User.Identity.Name, registryId, setting);
            if (setting.CRS_SETTINGS_ID <= 0)
            {
                strResult = "Registry, Contact, and Schedule Information have been saved, however there was an error saving Miscellaneous Information.  Please try again.<br /><br />";
                return false;
            }

            return true;
        }

        public void LoadForm(int id)
        {
            ResetForm();

            STD_REGISTRY registry = ServiceInterfaceManager.STD_REGISTRY_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, id);
            if (registry != null)
            {
                hideRegistryId.Value = registry.ID.ToString();

                txtRegistryName.Text = registry.NAME;
                txtRegistryCode.Text = registry.CODE;
                txtRegistryDescription.Text = registry.DESCRIPTION_TEXT;

                LoadUserLists();

                if (registry.REGISTRY_OWNER > 0) listRegistryOwner.SelectedValue = registry.REGISTRY_OWNER.ToString();
                if (registry.REGISTRY_ADMINISTRATOR > 0) listRegistryAdministrator.SelectedValue = registry.REGISTRY_ADMINISTRATOR.ToString();
                if (registry.REGISTRY_SUPPORT_CONTACT > 0) listSupportContact.SelectedValue = registry.REGISTRY_SUPPORT_CONTACT.ToString();

                SETTINGS setting = null;
                setting = ServiceInterfaceManager.SETTINGS_GET_REGISTRYNAME(HttpContext.Current.User.Identity.Name, registry.ID, "EtlScheduleManual");
                if (setting != null && setting.VALUE != "")
                    rblScheduleManual.SelectedValue = setting.VALUE;

                setting = ServiceInterfaceManager.SETTINGS_GET_REGISTRYNAME(HttpContext.Current.User.Identity.Name, registry.ID, "EtlScheduleAuto");
                if (setting != null && setting.VALUE != "")
                    rblScheduleAuto.SelectedValue = setting.VALUE;

                setting = ServiceInterfaceManager.SETTINGS_GET_REGISTRYNAME(HttpContext.Current.User.Identity.Name, registry.ID, "EtlScheduleAutoTime");
                if (setting != null && setting.VALUE != "")
                    listScheduleAutoTime.SelectedValue = setting.VALUE;

                if (rblScheduleAuto.SelectedIndex > 0)
                    listScheduleAutoTime.Enabled = true;

                setting = ServiceInterfaceManager.SETTINGS_GET_REGISTRYNAME(HttpContext.Current.User.Identity.Name, registry.ID, "UploadNoteTemplates");
                if (setting != null && setting.VALUE != "0")
                    chkbxAllowSurveys.Checked = true;
            }
        }

        private void LoadUserLists()
        {
            List<USERS> users = ServiceInterfaceManager.USERS_GET_ALL(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            listRegistryOwner.Items.Clear();
            listRegistryOwner.Items.Add(new ListItem("Select...", "0"));
            listRegistryOwner.AppendDataBoundItems = true;
            listRegistryOwner.DataSource = users;
            listRegistryOwner.DataBind();

            listRegistryAdministrator.Items.Clear();
            listRegistryAdministrator.Items.Add(new ListItem("Select...", "0"));
            listRegistryAdministrator.AppendDataBoundItems = true;
            listRegistryAdministrator.DataSource = users;
            listRegistryAdministrator.DataBind();

            listSupportContact.Items.Clear();
            listSupportContact.Items.Add(new ListItem("Select...", "0"));
            listSupportContact.AppendDataBoundItems = true;
            listSupportContact.DataSource = users;
            listSupportContact.DataBind();
        }

        public void ResetForm()
        {
            //TabControl.ActiveTab = TabControl.Tabs[0];
            pnlRegistryContainer.Visible = true;
            pnlContactContainer.Visible = false;
            pnlScheduleContainer.Visible = false;
            pnlMiscellaneousContainer.Visible = false;

            hideRegistryId.Value = string.Empty;

            txtRegistryName.Text = string.Empty;
            txtRegistryCode.Text = string.Empty;
            txtRegistryDescription.Text = string.Empty;

            LoadUserLists();

            rblScheduleManual.ClearSelection();
            rblScheduleAuto.ClearSelection();
            listScheduleAutoTime.ClearSelection();
            listScheduleAutoTime.Enabled = false;
            chkbxAllowSurveys.Checked = false;
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Ds_Selecting(sender, e);

                if (!UserSession.IsSystemAdministrator)
                {
                    linkRegistryAdd.Visible = false;
                }
                string searchColumn = ddlSearch.SelectedValue;
                string searchText = txtSearch.Text;

                e.InputParameters.Add("SEARCH_COLUMN", searchColumn);
                e.InputParameters.Add("SEARCH_TEXT", searchText);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnSearch_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            try
            {
                gridRegistry.DataBind();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnClear_Click(object sender, EventArgs e)
        {
            txtSearch.Text = "";
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            try
            {
                gridRegistry.DataBind();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnAddUser_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                mpeAddUser.Show();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void AdminUser_SearchClicked(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                mpeAddUser.Show();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void AdminUser_SearchCancelClicked(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                if (!string.IsNullOrEmpty(AdminUser.Username))
                {
                    mpeAddUser.Show();
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void AdminUser_SaveClicked(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                int id = 0;
                if (int.TryParse(hideRegistryId.Value, out id))
                {
                    LoadForm(id);
                    //TabControl.ActiveTab = TabControl.Tabs[1];
                    pnlRegistryContainer.Visible = false;
                    pnlContactContainer.Visible = true;
                    pnlScheduleContainer.Visible = false;
                    pnlMiscellaneousContainer.Visible = false;

                    lblResult.Text = "New User has been created and is now available in the drop down lists<br /><br />";
                }
                else
                {
                    lblResult.Text = "New User has been created, however you may have to refresh the page for them to be included in the drop down list<br /><br />";
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void AdminUser_CancelClicked(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void AdminUser_SaveRolesClicked(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                mpeAddUser.Show();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void RblScheduleAuto_SelectedIndexChanged(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                if (rblScheduleAuto.SelectedIndex > 0)
                {
                    listScheduleAutoTime.Enabled = true;
                }
                else
                {
                    listScheduleAutoTime.ClearSelection();
                    listScheduleAutoTime.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkRegistry_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                pnlRegistryContainer.Visible = true;
                pnlContactContainer.Visible = false;
                pnlScheduleContainer.Visible = false;
                pnlMiscellaneousContainer.Visible = false;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkContact_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                pnlRegistryContainer.Visible = false;
                pnlContactContainer.Visible = true;
                pnlScheduleContainer.Visible = false;
                pnlMiscellaneousContainer.Visible = false;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkSchedule_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                pnlRegistryContainer.Visible = false;
                pnlContactContainer.Visible = false;
                pnlScheduleContainer.Visible = true;
                pnlMiscellaneousContainer.Visible = false;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void LinkMiscellaneous_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                pnlRegistryContainer.Visible = false;
                pnlContactContainer.Visible = false;
                pnlScheduleContainer.Visible = false;
                pnlMiscellaneousContainer.Visible = true;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}